import { format } from "date-fns";
import { el } from "date-fns/locale";

/**
 * Παίρνει string μορφής "YYYY-MM-DDTHH:mm" και επιστρέφει σωστά διαμορφωμένη ημερομηνία
 */
export function formatDate(input: string | Date): string {
  try {
    if (typeof input === "string" && input.includes("T")) {
      const [datePart, timePart] = input.split("T");
      const [year, month, day] = datePart.split("-").map(Number);
      const [hour, minute] = timePart.split(":").map(Number);
      const localDate = new Date(year, month - 1, day, hour, minute);
      return format(localDate, "dd/MM/yyyy HH:mm", { locale: el });
    }

    const dateObj = new Date(input);
    return format(dateObj, "dd/MM/yyyy HH:mm", { locale: el });
  } catch {
    return "";
  }
}
