import api from './axios';

export const getEquipment = () => api.get('/equipment');
export const getEquipmentById = (id: string) => api.get(`/equipment/${id}`);
export const createEquipment = (data: any) => api.post('/equipment', data);
export const updateEquipment = (id: string, data: any) => api.put(`/equipment/${id}`, data);
export const deleteEquipment = (id: string) => api.delete(`/equipment/${id}`);
export const assignEquipment = (id: string, data: any) => api.post(`/equipment/${id}/assign`, data);
export const unassignEquipment = (id: string) => api.post(`/equipment/${id}/unassign`);
export const exportEquipment = () => api.get('/equipment/export/xlsx', { responseType: 'blob' });
export const getEquipmentStats = () => api.get('/equipment/stats/dashboard');
export const getQRCode = (id: string) => api.get(`/equipment/${id}/qrcode`, { responseType: 'blob' });
