import api from "../utils/axios";
import axios from "../utils/axios";

// === Fetch all payrolls for a year ===


// ✅ Τώρα το URL βγαίνει σωστά: http://localhost:5000/api/payrolls
export const fetchPayrolls = async (year?: number, name?: string, period?: string) => {
  try {
    const params: any = {};
    if (year) params.year = year;
    if (name) params.name = name;
    if (period) params.period = period;

const res = await api.get("/payrolls", { params });
    return res.data;
  } catch (err) {
    console.error("❌ fetchPayrolls error:", err);
    throw err;
  }
};


// === Fetch items (categories) of a specific payroll ===
export const fetchPayrollItems = async (payrollId: number) => {
  const res = await axios.get(`/payrolls/${payrollId}/items`);
  return res.data;
};

// === Add new payment ===
export const addPayrollPayment = async (data: {
  employee_id: number;
  payroll_id: number;
  item_id?: number;
  amount: number;
  method: string;
  notes?: string;
}) => {
  const res = await axios.post(`/payrolls/payments`, data);
  return res.data;
};
