import { Box, Button, Heading, VStack, SimpleGrid } from "@chakra-ui/react";
import { useNavigate } from "react-router-dom";

export default function VehiclesReports() {
  const navigate = useNavigate();

  return (
    <Box
      minH="100vh"
      bg="gray.50"
      display="flex"
      alignItems="center"
      justifyContent="center"
      p={4}
    >
      <VStack spacing={6} maxW="container.md" width="100%">
        <Heading size={{ base: "md", md: "lg" }} textAlign="center">
          Αναφορές Οχημάτων
        </Heading>

        <SimpleGrid columns={{ base: 1, sm: 2 }} spacing={4} width="100%">
          <Button colorScheme="blue" width="100%">
            Αναφορά Χρήσης Οχημάτων
          </Button>
          <Button colorScheme="teal" width="100%">
            Αναφορά Καυσίμων
          </Button>
          <Button colorScheme="orange" width="100%">
            Συμβάντα / Ζημιές
          </Button>
          <Button colorScheme="purple" width="100%">
            Συντήρηση & Service
          </Button>
        </SimpleGrid>

        <Button
          colorScheme="red"
          onClick={() => navigate(-1)}
          width={{ base: "100%", sm: "200px" }}
        >
          ⬅ Πίσω
        </Button>
      </VStack>
    </Box>
  );
}
