import {
  Box,
  Button,
  Heading,
  VStack,
  SimpleGrid,
} from "@chakra-ui/react";
import { useNavigate } from "react-router-dom";

export default function Vehicles() {
  const navigate = useNavigate();

  return (
    <Box
      minH="100vh"
      bg="gray.50"
      display="flex"
      alignItems="center"
      justifyContent="center"
      p={4}
    >
      <VStack spacing={6} width="100%" maxW="container.lg">
        <Heading size={{ base: "md", md: "lg" }} textAlign="center">
          Διαχείριση Στόλου
        </Heading>

        <SimpleGrid columns={{ base: 1, sm: 2, md: 2 }} spacing={4} width="100%">
          <Button colorScheme="blue" onClick={() => navigate("/vehicles/fleet")}>Διαχείριση Οχημάτων</Button>
          <Button colorScheme="teal">Έλεγχος Συντήρησης</Button>
          <Button colorScheme="yellow" onClick={() => navigate("/vehicles/logbook")}>Βιβλίο Κίνησης</Button>
          <Button colorScheme="purple" onClick={() => navigate("/vehicles/reports")}>Αναφορές</Button>
        </SimpleGrid>

        <Button colorScheme="red" onClick={() => navigate(-1)} width={{ base: "100%", sm: "200px" }}>
          ⬅ Πίσω
        </Button>
      </VStack>
    </Box>
  );
}
