import { Box, Heading, SimpleGrid, VStack, Text, Button } from "@chakra-ui/react";
import { useNavigate } from "react-router-dom";
import { ArrowBackIcon } from "@chakra-ui/icons";
import VehicleStatsWidget from "../components/VehicleStatsWidget";
import CashOverviewWidget from "../components/CashOverviewWidget";

export default function Stats() {
  const navigate = useNavigate();

  return (
    <Box minH="100vh" bg="gray.50" p={6}>
      <VStack spacing={6} align="start" maxW="container.xl" mx="auto">
        <Heading size="lg">📊 Live Στατιστικά</Heading>
        <Text color="gray.600">
          Παρακολούθησε σε πραγματικό χρόνο την κατάσταση των οχημάτων και τα οικονομικά δεδομένα.
        </Text>

        {/* --- GRID ΜΕ ΤΑ WIDGETS --- */}
        <SimpleGrid columns={{ base: 1, md: 2 }} spacing={6} width="100%">
          <VehicleStatsWidget />
          <CashOverviewWidget />
        </SimpleGrid>

        {/* --- Πίσω Button --- */}
        <Button
          leftIcon={<ArrowBackIcon />}
          colorScheme="red"
          onClick={() => navigate(-1)}
        >
          Πίσω
        </Button>
      </VStack>
    </Box>
  );
}
