import {
  Box,
  Button,
  Heading,
  Table,
  Thead,
  Tbody,
  Tr,
  Th,
  Td,
  VStack,
  Spinner,
  Text,
  HStack,
  useToast,
} from "@chakra-ui/react";
import { useEffect, useState } from "react";
import { useNavigate } from "react-router-dom";
import api from "../utils/axios";
import { ArrowBackIcon } from "@chakra-ui/icons";

export default function OverdueCustomers() {
  const [customers, setCustomers] = useState<any[]>([]);
  const [loading, setLoading] = useState(true);
  const toast = useToast();
  const navigate = useNavigate();

  useEffect(() => {
    const fetchOverdue = async () => {
      try {
        setLoading(true);
        const res = await api.get("/customers/overdue");
        setCustomers(res.data);
      } catch (err) {
        console.error(err);
        toast({ title: "❌ Σφάλμα φόρτωσης ληξιπρόθεσμων", status: "error" });
      } finally {
        setLoading(false);
      }
    };
    fetchOverdue();
  }, []);

  if (loading)
    return (
      <Box textAlign="center" py={20}>
        <Spinner size="xl" />
        <Text mt={3}>Φόρτωση ληξιπρόθεσμων...</Text>
      </Box>
    );

  return (
    <Box p={6} bg="gray.50" minH="100vh">
      <VStack align="stretch" spacing={6}>
        <HStack justify="space-between">
          <Button
            leftIcon={<ArrowBackIcon />}
            colorScheme="red"
            onClick={() => navigate(-1)}
          >
            Πίσω
          </Button>
          <Heading size="lg" color="orange.600">
            ⚠️ Ληξιπρόθεσμοι Πελάτες
          </Heading>
        </HStack>

        <Box bg="white" p={4} rounded="md" shadow="sm" overflowX="auto">
          <Table variant="striped" colorScheme="orange" size="sm">
            <Thead bg="gray.100">
              <Tr>
                <Th>Πελάτης</Th>
                <Th isNumeric>Υπόλοιπο (€)</Th>
              </Tr>
            </Thead>
            <Tbody>
              {customers.length > 0 ? (
                customers.map((c) => (
                  <Tr key={c.customer_id}>
                    <Td>{c.customer_name}</Td>
                    <Td isNumeric>{Number(c.balance).toFixed(2)}</Td>
                  </Tr>
                ))
              ) : (
                <Tr>
                  <Td colSpan={2} textAlign="center">
                    ✅ Δεν υπάρχουν ληξιπρόθεσμοι πελάτες.
                  </Td>
                </Tr>
              )}
            </Tbody>
          </Table>
        </Box>
      </VStack>
    </Box>
  );
}
