import {
  Box,
  Button,
  FormControl,
  FormLabel,
  Input,
  Heading,
  VStack,
  useToast,
} from "@chakra-ui/react";
import { useState } from "react";
import { useNavigate } from "react-router-dom";
import { useAuth } from "../context/AuthContext";
import axios from "../utils/axios"; // ή όπου έβαλες το αρχείο

export default function Login() {
  const [username, setUsername] = useState("");
  const [password, setPassword] = useState("");
  const { login } = useAuth();
  const navigate = useNavigate();
  const toast = useToast();
 
  const handleLogin = async (e: React.FormEvent) => {
    e.preventDefault();
    try {
      await login(username, password); // ✅ ΣΩΣΤΟ: καλούμε AuthContext
      toast({
        title: "Επιτυχής σύνδεση.",
        status: "success",
        duration: 2000,
        isClosable: true,
      });
      navigate("/dashboard");
    } catch (err) {
      console.error("❌ Login error:", err);
      toast({
        title: "Λάθος στοιχεία",
        status: "error",
        duration: 3000,
        isClosable: true,
      });
    }
  };

  return (
    <Box minH="100vh" bg="gray.50" display="flex" alignItems="center" justifyContent="center">
      <Box p={8} bg="white" boxShadow="md" borderRadius="md" w="full" maxW="sm">
        <Heading mb={6} size="lg" textAlign="center">
          Σύνδεση
        </Heading>
        <form onSubmit={handleLogin}>
          <VStack spacing={4}>
            <FormControl>
              <FormLabel>Όνομα χρήστη</FormLabel>
              <Input
                value={username}
                onChange={(e) => setUsername(e.target.value)}
                placeholder="π.χ. admin"
                required
              />
            </FormControl>
            <FormControl>
              <FormLabel>Κωδικός</FormLabel>
              <Input
                type="password"
                value={password}
                onChange={(e) => setPassword(e.target.value)}
                placeholder="********"
                required
              />
            </FormControl>
            <Button type="submit" colorScheme="blue" w="full">
              Σύνδεση
            </Button>
          </VStack>
        </form>
      </Box>
    </Box>
  );
}