import {
  Box,
  Button,
  FormControl,
  FormLabel,
  Input,
  Textarea,
  Select,
  VStack,
  Heading,
  useToast,
} from "@chakra-ui/react";
import { useState } from "react";
import { useNavigate } from "react-router-dom";
import axios from "../utils/axios";
import { useAuth } from "../context/AuthContext";
import { formatDate } from "../utils/formatDate";


export default function LeaveRequestPage() {
  const { user } = useAuth();
  const navigate = useNavigate();
  const toast = useToast();

  const [formData, setFormData] = useState({
    from_date: "",
    to_date: "",
    type: "",
    reason: "",
  });

  const handleChange = (e) => {
    const { name, value } = e.target;
    setFormData((prev) => ({ ...prev, [name]: value }));
  };

  const handleSubmit = async (e) => {
    e.preventDefault();
    try {
      await axios.post("/leaves", {
        user_id: user.id,
        branch_id: user.branch_id,
        ...formData,
      });
      toast({ title: "Το αίτημα υποβλήθηκε.", status: "success" });
      navigate("/leaves");
    } catch (err) {
      console.error(err);
      toast({ title: "Σφάλμα υποβολής.", status: "error" });
    }
  };

  return (
    <Box p={4} maxW="xl" mx="auto">
      <Heading size="lg" mb={4}>Καταχώριση Αιτήματος Άδειας</Heading>
      <form onSubmit={handleSubmit}>
        <VStack spacing={4}>
          <FormControl isRequired>
  <FormLabel>Από Ημερομηνία</FormLabel>
  <Input
    type="datetime-local"
    name="from_date"
    value={formData.from_date}
    onChange={handleChange}
  />
  {formData.from_date && (
    <Box mt={1} fontSize="sm" color="gray.600">
      Επιλέχθηκε: {formatDate(formData.from_date)}
    </Box>
  )}
</FormControl>

<FormControl isRequired>
  <FormLabel>Έως Ημερομηνία</FormLabel>
  <Input
    type="datetime-local"
    name="to_date"
    value={formData.to_date}
    onChange={handleChange}
  />
  {formData.to_date && (
    <Box mt={1} fontSize="sm" color="gray.600">
      Επιλέχθηκε: {formatDate(formData.to_date)}
    </Box>
  )}
</FormControl>

          <FormControl isRequired>
            <FormLabel>Τύπος Άδειας</FormLabel>
            <Select name="type" onChange={handleChange}>
              <option value="">-- Επιλογή --</option>
              <option value="κανονική">Κανονική</option>
              <option value="ασθένεια">Ασθένεια</option>
              <option value="άλλη">Άλλη</option>
            </Select>
          </FormControl>
          <FormControl>
            <FormLabel>Αιτιολογία</FormLabel>
            <Textarea name="reason" onChange={handleChange} />
          </FormControl>
          <Button colorScheme="blue" type="submit" width="full">
            Υποβολή
          </Button>
          <Button onClick={() => navigate(-1)} colorScheme="gray" variant="outline" width="full">
            Πίσω
          </Button>
        </VStack>
      </form>
    </Box>
  );
}
