import {
  Box,
  Button,
  Heading,
  VStack,
  SimpleGrid,
} from "@chakra-ui/react";
import { useNavigate } from "react-router-dom";

export default function LeaveDashboard() {
  const navigate = useNavigate();

  return (
    <Box
      minH="100vh"
      bg="gray.100"
      display="flex"
      alignItems="center"
      justifyContent="center"
      p={4}
    >
      <VStack spacing={6} width="100%" maxW="container.md">
        <Heading size="lg" textAlign="center">
          Διαχείριση Αδειών
        </Heading>

        <SimpleGrid columns={{ base: 1, sm: 2 }} spacing={4} width="100%">
          <Button colorScheme="blue" onClick={() => navigate("/leaves/request")}>
            Καταχώριση Αιτήματος
          </Button>
          <Button colorScheme="teal" onClick={() => navigate("/leaves/approvals")}>
            Εγκρίσεις
          </Button>
          <Button colorScheme="purple" onClick={() => navigate("/leaves/calendar")}>
            Ημερολόγιο
          </Button>
          <Button colorScheme="orange" onClick={() => navigate("/leaves/reports")}>
            Αναφορές
          </Button>
        </SimpleGrid>

        <Button
          onClick={() => navigate(-1)}
          colorScheme="gray"
          variant="outline"
          width={{ base: "100%", sm: "200px" }}
        >
          Πίσω
        </Button>
      </VStack>
    </Box>
  );
}
