import {
  Box,
  Button,
  Heading,
  VStack,
  SimpleGrid,
} from "@chakra-ui/react";
import { useNavigate } from "react-router-dom";

export default function HumanResources() {
  const navigate = useNavigate();

  return (
    <Box
      minH="100vh"
      bg="gray.100"
      display="flex"
      alignItems="center"
      justifyContent="center"
      p={4}
    >
      <VStack spacing={6} width="100%" maxW="container.md">
        <Heading size="lg" textAlign="center">
          Ανθρώπινο Δυναμικό
        </Heading>

        <SimpleGrid columns={{ base: 1, sm: 2 }} spacing={4} width="100%">
          {/* ✅ Πάει στη λίστα υπαλλήλων */}
          <Button
            colorScheme="teal"
            onClick={() => navigate("/employees")}
          >
            Υπάλληλοι
          </Button>

          {/* placeholder - θα συνδέσουμε αργότερα */}
          <Button
            colorScheme="blue"
            onClick={() => navigate("/hr/contracts")}
            isDisabled
          >
            Αρχεία & Συμβάσεις
          </Button>

          {/* ✅ Πάει στις άδειες */}
          <Button
            colorScheme="green"
            onClick={() => navigate("/leaves")}
          >
            Άδειες
          </Button>

          {/* placeholder - θα συνδέσουμε αργότερα */}
         <Button colorScheme="orange" onClick={() => navigate("/payrolls")}>
  Μισθοδοσία
</Button>
        </SimpleGrid>

        <Button
          onClick={() => navigate(-1)}
          colorScheme="red"
          width={{ base: "100%", sm: "200px" }}
        >
          Πίσω
        </Button>
      </VStack>
    </Box>
  );
}
