import { useParams } from 'react-router-dom';
import { useEffect, useState } from 'react';
import { getEquipmentById, getQRCode } from '../utils/equipmentAPI';

export default function EquipmentDetail() {
  const { id } = useParams();
  const [equipment, setEquipment] = useState<any>(null);
  const [qrCodeUrl, setQrCodeUrl] = useState<string | null>(null);

  useEffect(() => {
    getEquipmentById(id!).then(res => setEquipment(res.data));
    getQRCode(id!).then(res => {
      const url = window.URL.createObjectURL(res.data);
      setQrCodeUrl(url);
    });
  }, [id]);

  if (!equipment) return <p>Loading...</p>;

  return (
    <div className="p-6">
      <h2 className="text-2xl font-bold mb-3">{equipment.brand} {equipment.model}</h2>
      <p><strong>Category:</strong> {equipment.category_code}</p>
      <p><strong>Status:</strong> {equipment.status_code}</p>
      <p><strong>Location:</strong> {equipment.location_hint}</p>
      {qrCodeUrl && (
        <div className="mt-4">
          <img src={qrCodeUrl} alt="QR Code" className="w-32" />
          <p className="text-xs text-gray-500 mt-1">Scan to identify asset</p>
        </div>
      )}
    </div>
  );
}
