import {
  Box,
  Button,
  Heading,
  VStack,
  SimpleGrid,
} from "@chakra-ui/react";
import { useNavigate } from "react-router-dom";

export default function EltaDashboard() {
  const navigate = useNavigate();

  return (
    <Box
      minH="100vh"
      bg="gray.50"
      display="flex"
      alignItems="center"
      justifyContent="center"
      p={4}
    >
      <VStack spacing={6} width="100%" maxW="container.lg">
        <Heading size={{ base: "md", md: "lg" }} textAlign="center">
          Ε.Λ.Τ.Α - Ενότητες
        </Heading>

        <SimpleGrid columns={{ base: 1, sm: 2, md: 3 }} spacing={4} width="100%">
          <Button colorScheme="purple" onClick={() => navigate("/elta/shipments")}>
            Αποστολές ΕΛΤΑ
          </Button>
          <Button colorScheme="yellow" onClick={() => navigate("/elta/payments")}>
            Πληρωμές ΕΛΤΑ
          </Button>
          <Button colorScheme="pink" onClick={() => navigate("/elta/statistics")}>
            Στατιστικά ΕΛΤΑ
          </Button>
        </SimpleGrid>

        <Button
          onClick={() => navigate(-1)}
          colorScheme="red"
          width={{ base: "100%", sm: "200px" }}
        >
          ⬅ Πίσω
        </Button>
      </VStack>
    </Box>
  );
}
