import {
  Box,
  Button,
  Heading,
  VStack,
  SimpleGrid,
} from "@chakra-ui/react";
import { useNavigate } from "react-router-dom";
import { useAuth } from "../context/AuthContext";
import EquipmentStatsChart from '../components/EquipmentStatsChart';

export default function Dashboard() {
  const navigate = useNavigate();
  const { user, logout } = useAuth();

  const handleLogout = () => {
    logout();
    navigate("/login");
  };

  return (
    <Box
      minH="100vh"
      bg="gray.50"
      display="flex"
      alignItems="center"
      justifyContent="center"
      p={4}
    >
      <VStack spacing={6} width="100%" maxW="container.lg">
        <Heading size={{ base: "md", md: "lg" }} textAlign="center">
          Κεντρικό Μενού
        </Heading>

        <SimpleGrid columns={{ base: 1, sm: 2, md: 3 }} spacing={4} width="100%">
          {["admin", "branch_admin"].includes(user?.role) && (
            <>
              <Button colorScheme="blue" onClick={() => navigate("/users")}>
                Διαχείριση Χρηστών
              </Button>
              <Button colorScheme="teal" onClick={() => navigate("/branches")}>
                Υποκαταστήματα
              </Button>
            </>
          )}
          <Button colorScheme="purple" onClick={() => navigate("/vehicles")}>
            Οχήματα
          </Button>
          <Button colorScheme="green" onClick={() => navigate("/accounting")}>
            Λογιστήριο / Πελατολόγιο
</Button>
          <Button colorScheme="pink" onClick={() => navigate("/human-resources")}>
  Ανθρώπινο Δυναμικό
</Button>
<Button colorScheme="red" onClick={() => navigate("/customer")}>
  Customer Πελατών
</Button>
<Button colorScheme="orange" onClick={() => navigate("/elta")}>
  ΕΛ.ΤΑ
</Button>
<Button colorScheme="yellow" onClick={() => navigate("/stats")}>
  Live Στατιστικά
</Button>
<Button colorScheme="cyan" onClick={() => {}} width="100%">
            Εξοπλισμός
          </Button>
        </SimpleGrid>

        <Button
          onClick={handleLogout}
          colorScheme="red"
          width={{ base: "100%", sm: "200px" }}
        >
          Αποσύνδεση
        </Button>
      </VStack>
    </Box>

  );
}
