import { Box, Heading, VStack, Button, SimpleGrid } from "@chakra-ui/react";
import { useNavigate } from "react-router-dom";

export default function Customers() {
  const navigate = useNavigate();

  return (
    <Box
      minH="100vh"
      p={6}
      bg="gray.50"
      display="flex"
      alignItems="center"
      justifyContent="center"
    >
      <VStack spacing={6} maxW="container.md" width="100%">
        <Heading size={{ base: "md", md: "lg" }} textAlign="center" color="teal.600">
          💼 Διαχείριση Πελατών
        </Heading>

        <SimpleGrid columns={{ base: 1, sm: 2 }} spacing={4} width="100%">
          <Button
            colorScheme="green"
            width="100%"
            onClick={() => navigate("/customers/list")}
          >
            📋 Προβολή Πελατών
          </Button>

          <Button
            colorScheme="blue"
            width="100%"
            onClick={() => navigate("/customers/new")}
          >
            ➕ Προσθήκη Νέου Πελάτη
          </Button>

          <Button
  colorScheme="pink"
  width="100%"
  onClick={() => navigate("/invoice-payments")}
>
  💰 Καταχώρηση Εισπράξεων
</Button>


          <Button
            colorScheme="teal"
            width="100%"
            onClick={() => navigate("/customers/ledger")}
          >
            📊 Καρτέλα Πελάτη
          </Button>

          <Button
            colorScheme="orange"
            width="100%"
	    onClick={() => navigate("/invoices")}
          >
            🧾 Προσθήκη Τιμολογίου
          </Button>

          <Button
            colorScheme="red"
            width="100%"
            onClick={() => navigate("/invoices/overdue")}
          >
            ⚠️ Ληξιπρόθεσμα
          </Button>
        </SimpleGrid>

        <Button
          colorScheme="red"
          
          width={{ base: "100%", sm: "200px" }}
          onClick={() => navigate(-1)}
        >
          ⬅ Πίσω
        </Button>
      </VStack>
    </Box>
  );
}
