import {
  Box,
  Button,
  Heading,
  VStack,
  SimpleGrid,
} from "@chakra-ui/react";
import { useNavigate } from "react-router-dom";

export default function CustomerDashboard() {
  const navigate = useNavigate();

  return (
    <Box
      minH="100vh"
      bg="gray.50"
      display="flex"
      alignItems="center"
      justifyContent="center"
      p={4}
    >
      <VStack spacing={6} width="100%" maxW="container.lg">
        <Heading size={{ base: "md", md: "lg" }} textAlign="center">
          Customer Πελατών
        </Heading>

        <SimpleGrid columns={{ base: 1, sm: 2, md: 3 }} spacing={4} width="100%">
          <Button colorScheme="blue" onClick={() => navigate("/customer/requests")}>
            Αιτήματα Πελατών
          </Button>
          <Button colorScheme="green" onClick={() => navigate("/customer/feedback")}>
            Feedback / Παράπονα
          </Button>
          <Button colorScheme="orange" onClick={() => navigate("/customer/statistics")}>
            Στατιστικά Πελατών
          </Button>
        </SimpleGrid>

        <Button
          onClick={() => navigate(-1)}
          colorScheme="red"
          width={{ base: "100%", sm: "200px" }}
        >
          ⬅ Πίσω
        </Button>
      </VStack>
    </Box>
  );
}
