import { Box, Button, Heading, VStack, SimpleGrid } from "@chakra-ui/react";
import { useNavigate } from "react-router-dom";

export default function CashMenu() {
  const navigate = useNavigate();

  return (
    <Box minH="100vh" p={4} bg="gray.50" display="flex" alignItems="center" justifyContent="center">
      <VStack spacing={6} maxW="container.md" width="100%">
        <Heading size={{ base: "md", md: "lg" }} textAlign="center">
          Ταμεία Καταστημάτων
        </Heading>

        <SimpleGrid columns={{ base: 1, sm: 2 }} spacing={4} width="100%">
          <Button colorScheme="green" onClick={() => navigate("/cash-entry")}>
  Καταχώρηση Ταμείου
</Button>

          <Button colorScheme="blue" onClick={() => navigate("/accounting/cash-overview")}>
            Ταμείο Καταστήματος
          </Button>
          <Button colorScheme="orange" onClick={() => navigate("/accounting/cash-reports")}>
            Αναφορές
          </Button>
          <Button colorScheme="purple" onClick={() => navigate("/accounting/end-of-day")}>
            Κλείσιμο Ημέρας
          </Button>
        </SimpleGrid>

        <Button
          colorScheme="red"
          onClick={() => navigate(-1)}
          width={{ base: "100%", sm: "200px" }}
        >
          ⬅ Πίσω
        </Button>
      </VStack>
    </Box>
  );
}
