import { useEffect, useState } from "react";
import { useParams, useNavigate } from "react-router-dom";
import axios from "../utils/axios";
import { useToast } from "@chakra-ui/react";
import CashEntryForm from "../components/CashEntryForm";
import DatePicker from "react-datepicker";
import { el } from "date-fns/locale";
import "react-datepicker/dist/react-datepicker.css";


export default function CashEntryPage() {
  const { id } = useParams();
  const navigate = useNavigate();
  const toast = useToast();
  const [initialData, setInitialData] = useState(null);
  const [loading, setLoading] = useState(false);

  useEffect(() => {
    if (!id) return;
    setLoading(true);
    axios
      .get(`/cash-sessions/${id}`)
      .then((res) => {
        setInitialData(res.data);
      })
      .catch((err) => {
        console.error("❌ Σφάλμα φόρτωσης:", err);
        toast({ title: "Σφάλμα ανάκτησης", status: "error" });
        navigate(-1);
      })
      .finally(() => setLoading(false));
  }, [id]);

  return (
    <CashEntryForm
      initialData={initialData}
      onSuccess={() => navigate("/accounting/cash-overview")}
      onClose={() => navigate(-1)}
    />
  );
}
