import { Box, Button, Heading, VStack, SimpleGrid } from "@chakra-ui/react";
import { useNavigate } from "react-router-dom";

export default function Accounting() {
  const navigate = useNavigate();

  return (
    <Box minH="100vh" p={4} bg="gray.50" display="flex" alignItems="center" justifyContent="center">
      <VStack spacing={6} maxW="container.md" width="100%">
        <Heading size={{ base: "md", md: "lg" }} textAlign="center">
          Λογιστήριο
        </Heading>

        <SimpleGrid columns={{ base: 1, sm: 2 }} spacing={4} width="100%">
          <Button colorScheme="blue" onClick={() => navigate("/accounting/cash-menu")} width="100%">
  Ταμεία Καταστημάτων
</Button>
          <Button colorScheme="teal" onClick={() => navigate("/accounting/customers")} width="100%">
  Εισπράξεις Πελατών / Πελατολόγιο 
</Button>
          <Button colorScheme="orange" onClick={() => {}} width="100%">
            Έσοδα / Έξοδα
          </Button>
          <Button colorScheme="purple" onClick={() => {}} width="100%">
            Εκκαθαρίσεις
          </Button>
        </SimpleGrid>

        <Button
          colorScheme="red"
          onClick={() => navigate(-1)}
          width={{ base: "100%", sm: "200px" }}
        >
          ⬅ Πίσω
        </Button>
      </VStack>
    </Box>
  );
}
