import { useEffect, useState } from "react";
import axios from "../utils/axios";

export interface Branch {
  id: number;
  name: string;
  code: string;
  address: string;
  city: string;
  phone?: string;
}

export default function useBranches() {
  const [branches, setBranches] = useState<Branch[]>([]);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState<string | null>(null);

  useEffect(() => {
    const fetchBranches = async () => {
      try {
        const res = await axios.get("/branches");
        setBranches(res.data);
      } catch (err: any) {
        console.error("❌ Error fetching branches:", err);
        setError("Αποτυχία φόρτωσης καταστημάτων.");
      } finally {
        setLoading(false);
      }
    };
    fetchBranches();
  }, []);

  return { branches, loading, error };
}
