export const StatusBadge = ({ status }: { status: string }) => {
  const colorMap: Record<string, string> = {
    active: 'bg-green-100 text-green-800',
    maintenance: 'bg-yellow-100 text-yellow-800',
    retired: 'bg-gray-100 text-gray-700',
    pending_setup: 'bg-blue-100 text-blue-800'
  };
  return (
    <span className={`px-2 py-1 rounded text-xs font-semibold ${colorMap[status] || 'bg-gray-100'}`}>
      {status.toUpperCase()}
    </span>
  );
};
