// src/components/ProtectedRoute.tsx
import { Navigate } from "react-router-dom";
import { useAuth } from "../context/AuthContext";

export default function ProtectedRoute({ children }: { children: JSX.Element }) {
  const { auth } = useAuth();

  // Αν δεν υπάρχει token στο localStorage ή auth είναι false, redirect στο login
  const token = localStorage.getItem("token");

  if (!auth || !token) {
    return <Navigate to="/login" replace />;
  }

  return children;
}
