import { useEffect, useState } from "react";
import { PieChart, Pie, Tooltip, Cell, ResponsiveContainer } from "recharts";
import { getEquipmentStats } from "../utils/equipmentAPI";
import { Box, Text, Spinner } from "@chakra-ui/react";

const COLORS = ["#10b981", "#f59e0b", "#3b82f6", "#9ca3af"];

export default function EquipmentStatsChart() {
  const [stats, setStats] = useState<any[]>([]);
  const [loading, setLoading] = useState(true);

  const fetchData = async () => {
    try {
      const res = await getEquipmentStats();
      setStats(res.data);
      setLoading(false);
    } catch (err) {
      console.error("Error fetching stats:", err);
      setLoading(false);
    }
  };

  // 👇 Αυτό είναι το “Live refresh” κομμάτι
  useEffect(() => {
    fetchData(); // αρχική φόρτωση
    const interval = setInterval(fetchData, 60000); // ανανέωση κάθε 60 δευτερόλεπτα
    return () => clearInterval(interval); // cleanup όταν αλλάξει σελίδα
  }, []);

  if (loading) {
    return (
      <Box display="flex" justifyContent="center" alignItems="center" h="200px">
        <Spinner size="lg" />
      </Box>
    );
  }

  if (!stats.length) {
    return (
      <Box textAlign="center" py={6}>
        <Text color="gray.400">Δεν υπάρχουν διαθέσιμα δεδομένα</Text>
      </Box>
    );
  }

  return (
    <ResponsiveContainer width="100%" height={250}>
      <PieChart>
        <Pie
          data={stats}
          dataKey="total"
          nameKey="status_code"
          outerRadius={80}
          label
        >
          {stats.map((entry, index) => (
            <Cell key={index} fill={COLORS[index % COLORS.length]} />
          ))}
        </Pie>
        <Tooltip />
      </PieChart>
    </ResponsiveContainer>
  );
}
