import { useEffect, useState } from "react";
import { Box, Heading, Text, Spinner, Table, Thead, Tbody, Tr, Th, Td } from "@chakra-ui/react";
import api from "../utils/axios";

export default function CashOverview() {
  const [stats, setStats] = useState<any[]>([]);
  const [loading, setLoading] = useState(true);

  const fetchData = async () => {
    try {
      const res = await api.get("/cash/stats/dashboard");
      setStats(res.data);
      setLoading(false);
    } catch (err) {
      console.error("Error fetching cash stats:", err);
      setLoading(false);
    }
  };

  useEffect(() => {
    fetchData();
    const interval = setInterval(fetchData, 60000);
    return () => clearInterval(interval);
  }, []);

  if (loading) return <Spinner size="lg" />;

  return (
    <Box bg="white" p={4} rounded="xl" shadow="md" border="1px solid" borderColor="gray.100">
      <Heading size="md" mb={4}>Σύνοψη Ταμείων Ανά Υποκατάστημα</Heading>
      <Table variant="simple">
        <Thead>
          <Tr>
            <Th>Κατάστημα</Th>
            <Th>Τύπος</Th>
            <Th isNumeric>Δηλωθέν</Th>
            <Th isNumeric>Σύστημα</Th>
            <Th isNumeric>Διαφορά</Th>
          </Tr>
        </Thead>
        <Tbody>
          {stats.map((s, idx) => (
            <Tr key={idx}>
              <Td>{s.branch_name}</Td>
              <Td>{s.cash_type}</Td>
              <Td isNumeric>{s.total_declared?.toFixed(2)} €</Td>
              <Td isNumeric>{s.total_system?.toFixed(2)} €</Td>
              <Td isNumeric color={s.total_diff >= 0 ? "green.500" : "red.500"}>
                {s.total_diff?.toFixed(2)} €
              </Td>
            </Tr>
          ))}
        </Tbody>
      </Table>
    </Box>
  );
}
