import { Button } from "@chakra-ui/react";
import { DownloadIcon } from "@chakra-ui/icons";
import api from "../utils/axios";

export default function CashExportButton({ date }: { date: string }) {
  const handleExport = async () => {
    try {
      const res = await api.get(`/cash/export/xlsx?date=${date}`, {
        responseType: "blob",
      });

      const blob = new Blob([res.data], {
        type: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
      });
      const url = window.URL.createObjectURL(blob);
      const a = document.createElement("a");
      a.href = url;
      a.download = `cash-report-${date}.xlsx`;
      a.click();
    } catch (err) {
      console.error("Export failed:", err);
    }
  };

  return (
    <Button
      colorScheme="green"
      leftIcon={<DownloadIcon />}
      onClick={handleExport}
    >
      Εξαγωγή Excel
    </Button>
  );
}
