import { Select, Spinner, Text } from "@chakra-ui/react";
import useBranches from "../hooks/useBranches";

interface Props {
  value?: number;
  onChange: (branchId: number) => void;
  disabled?: boolean;
}

export default function BranchSelect({ value, onChange, disabled }: Props) {
  const { branches, loading, error } = useBranches();

  if (loading) return <Spinner size="sm" />;
  if (error) return <Text color="red.500">{error}</Text>;

  return (
    <Select
      placeholder="Επιλέξτε κατάστημα"
      value={value ?? ""}
      onChange={(e) => onChange(Number(e.target.value))}
      isDisabled={disabled}
    >
      {branches.map((branch) => (
        <option key={branch.id} value={branch.id}>
          {branch.name}
        </option>
      ))}
    </Select>
  );
}
