import { BrowserRouter, Routes, Route, Navigate } from "react-router-dom";
import Login from "./pages/Login";
import Dashboard from "./pages/Dashboard";
import { AuthProvider } from "./context/AuthContext";
import ProtectedRoute from "./components/ProtectedRoute";
import Users from "./pages/Users";
import Vehicles from "./pages/Vehicles";
import FleetManagement from "./pages/FleetManagement";
import Branches from "./pages/Branches";
import VehicleLogbookPage from "./pages/VehicleLogbookPage";
import VehiclesReports from "./pages/VehiclesReports";
import Accounting from "./pages/Accounting";
import CashMenu from "./pages/CashMenu";
import CashOverview from "./pages/CashOverview";
import CashEntry from "./pages/CashEntry"; // νέα σελίδα με fetch + φόρμα
import HumanResources from "./pages/HumanResources";
import LeaveDashboard from "./pages/LeaveDashboard";
import LeaveRequestPage from "./pages/LeaveRequestPage";
import CustomerDashboard from "./pages/CustomerDashboard";
import EltaDashboard from "./pages/EltaDashboard";
import Customers from "./pages/Customers";
import Stats from "./pages/Stats";
import EmployeesPage from "./pages/EmployeesPage";
import EmployeeForm from "./components/EmployeeForm";
import PayrollDashboard from "./pages/PayrollDashboard";
import PayrollForm from "./components/PayrollForm";
import CustomerList from "./pages/CustomerList";
import CustomerForm from "./pages/CustomerForm";
import CustomerLedger from "./pages/CustomerLedger";
import CustomerImport from "./components/CustomerImport"; 
// ή "./pages/CustomerImport" ανάλογα με το structure σου
import InvoicePayments from "./pages/InvoicePayments";
import InvoiceDashboard from "./pages/InvoiceDashboard";
import InvoiceForm from "./pages/InvoiceForm";
import PaymentsDashboard from "./pages/PaymentsDashboard";


function App() {
  return (
    <AuthProvider>
      <BrowserRouter>
        <Routes>
          <Route path="/login" element={<Login />} />

          <Route
            path="/dashboard"
            element={
              <ProtectedRoute>
                <Dashboard />
              </ProtectedRoute>
            }
          />

          <Route
            path="/users"
            element={
              <ProtectedRoute>
                <Users />
              </ProtectedRoute>
            }
          />

          <Route
            path="/vehicles"
            element={
              <ProtectedRoute>
                <Vehicles />
              </ProtectedRoute>
            }
          />

          <Route
            path="/vehicles/fleet"
            element={
              <ProtectedRoute>
                <FleetManagement />
              </ProtectedRoute>
            }
          />

          <Route
            path="/vehicles/logbook"
            element={
              <ProtectedRoute>
                <VehicleLogbookPage />
              </ProtectedRoute>
            }
          />

          <Route
            path="/vehicles/reports"
            element={
              <ProtectedRoute>
                <VehiclesReports />
              </ProtectedRoute>
            }
          />

          <Route
            path="/branches"
            element={
              <ProtectedRoute>
                <Branches />
              </ProtectedRoute>
            }
          />

          <Route
            path="/accounting"
            element={
              <ProtectedRoute>
                <Accounting />
              </ProtectedRoute>
            }
          />
<Route
  path="/accounting/customers"
  element={
    <ProtectedRoute>
      <Customers />
    </ProtectedRoute>
  }
/>

<Route
  path="/customers/list"
  element={
    <ProtectedRoute>
      <CustomerList />
    </ProtectedRoute>
  }
/>

<Route
  path="/customers/new"
  element={
    <ProtectedRoute>
      <CustomerForm />
    </ProtectedRoute>
  }
/>

<Route
  path="/customers/edit/:id"
  element={
    <ProtectedRoute>
      <CustomerForm />
    </ProtectedRoute>
  }
/>

<Route
  path="/customers/ledger"
  element={
    <ProtectedRoute>
      <CustomerLedger />
    </ProtectedRoute>
  }
/>

          <Route
            path="/accounting/cash-menu"
            element={
              <ProtectedRoute>
                <CashMenu />
              </ProtectedRoute>
            }
          />

          <Route
            path="/accounting/cash-overview"
            element={
              <ProtectedRoute>
                <CashOverview />
              </ProtectedRoute>
            }
          />

          <Route
            path="/cash-entry"
            element={
              <ProtectedRoute>
                <CashEntry />
              </ProtectedRoute>
            }
          />

          <Route
            path="/cash-entry/:id"
            element={
              <ProtectedRoute>
                <CashEntry />
              </ProtectedRoute>
            }
          />
<Route
  path="/human-resources"
  element={
    <ProtectedRoute>
      <HumanResources />
    </ProtectedRoute>
  }
/>
<Route
  path="/leaves"
  element={
    <ProtectedRoute>
      <LeaveDashboard />
    </ProtectedRoute>
  }
/>
<Route
  path="/leaves/request"
  element={
    <ProtectedRoute>
      <LeaveRequestPage />
    </ProtectedRoute>
  }
/>
<Route path="/stats" element={<Stats />} />
<Route path="/accounting/customers" element={<ProtectedRoute><Customers /></ProtectedRoute>} />
<Route path="/customer" element={<CustomerDashboard />} />
<Route path="/elta" element={<EltaDashboard />} />
<Route
  path="/employees"
  element={
    <ProtectedRoute>
      <EmployeesPage />
    </ProtectedRoute>
  }
/>

<Route
  path="/employees/new"
  element={
    <ProtectedRoute>
      <EmployeeForm />
    </ProtectedRoute>
  }
/>

<Route
  path="/employees/edit/:id"
  element={
    <ProtectedRoute>
      <EmployeeForm />
    </ProtectedRoute>
  }
/>
<Route path="/payrolls" element={<ProtectedRoute><PayrollDashboard /></ProtectedRoute>} />
<Route path="/payrolls/new" element={<ProtectedRoute><PayrollForm /></ProtectedRoute>} />
<Route path="/payrolls/edit/:id" element={<ProtectedRoute><PayrollForm /></ProtectedRoute>} />
<Route
  path="/customers/:id/ledger"
  element={
    <ProtectedRoute>
      <CustomerLedger />
    </ProtectedRoute>
  }
/>

<Route path="/customers/import" element={<CustomerImport />} />
<Route
  path="/invoices"
  element={
    <ProtectedRoute>
      <InvoiceDashboard />
    </ProtectedRoute>
  }
/>
<Route
  path="/invoices/edit/:id"
  element={
    <ProtectedRoute>
      <InvoiceForm />
    </ProtectedRoute>
  }
/>

<Route
  path="/invoices/new"
  element={
    <ProtectedRoute>
      <InvoiceForm />
    </ProtectedRoute>
  }
/>
<Route
  path="/invoice-payments"
  element={
    <ProtectedRoute>
      <PaymentsDashboard />
    </ProtectedRoute>
  }
/>

<Route
  path="/invoice-payments/new"
  element={
    <ProtectedRoute>
      <InvoicePayments />
    </ProtectedRoute>
  }
/>

          <Route path="/" element={<Navigate to="/login" replace />} />
          <Route path="*" element={<Navigate to="/login" replace />} />
        </Routes>
      </BrowserRouter>
    </AuthProvider>
  );
}

export default App;
