import { formatDistance } from "./fi/_lib/formatDistance.js";
import { formatLong } from "./fi/_lib/formatLong.js";
import { formatRelative } from "./fi/_lib/formatRelative.js";
import { localize } from "./fi/_lib/localize.js";
import { match } from "./fi/_lib/match.js";

/**
 * @category Locales
 * @summary Finnish locale.
 * @language Finnish
 * @iso-639-2 fin
 * @author Pyry-Samuli Lahti [@Pyppe](https://github.com/Pyppe)
 * @author Edo Rivai [@mikolajgrzyb](https://github.com/mikolajgrzyb)
 * @author Samu Juvonen [@sjuvonen](https://github.com/sjuvonen)
 */
export const fi = {
  code: "fi",
  formatDistance: formatDistance,
  formatLong: formatLong,
  formatRelative: formatRelative,
  localize: localize,
  match: match,
  options: {
    weekStartsOn: 1 /* Monday */,
    firstWeekContainsDate: 4,
  },
};

// Fallback for modularized imports:
export default fi;
