import express from "express";
import cors from "cors";
import dotenv from "dotenv";
import jwt from "jsonwebtoken";
import userRoutes from "./routes/userRoutes.js";
import authRoutes from "./routes/auth.js";
import vehicleRoutes from "./routes/vehicleRoutes.js";
import vehicleDocumentRoutes from "./routes/vehicleDocumentRoutes.js";
import path from "path";
import { fileURLToPath } from "url";

dotenv.config();
const app = express();
app.use(cors());
app.use(express.json());

// 🔐 Middleware για προστατευμένα routes (όχι για /api/auth)
app.use("/api", (req, res, next) => {
  if (req.path.startsWith("/auth")) {
    return next(); // μην ελέγχεις το token για login/register
  }

  const authHeader = req.headers.authorization;
  console.log("🔐 Incoming token:", authHeader);

  if (!authHeader || !authHeader.startsWith("Bearer ")) {
    return res.status(401).json({ message: "No token provided" });
  }

  const token = authHeader.split(" ")[1];

  try {
    const decoded = jwt.verify(token, process.env.JWT_SECRET);
    req.user = decoded;
    next();
  } catch (err) {
    return res.status(401).json({ message: "Invalid token" });
  }
});
const __filename = fileURLToPath(import.meta.url);
const __dirname = path.dirname(__filename);
// ✅ Routes
app.use("/api/users", userRoutes);
app.use("/api/auth", authRoutes);
app.use("/api/vehicles", vehicleRoutes);
app.use("/api/vehicles", vehicleDocumentRoutes);
app.use("/uploads", express.static("uploads")); // serve αρχεία
app.use("/uploads", express.static(path.join(__dirname, "uploads")));
app.use("/api/documents", vehicleDocumentRoutes);
// 🚀 Start server
app.listen(5000, () => {
  console.log("Server running on port 5000");
});
