import express from "express";
import { upload } from "../utils/upload.js";
import {
  uploadDocument,
  getVehicleDocuments,
  downloadDocument,
  deleteDocument
} from "../controllers/vehicleDocumentController.js";

const router = express.Router();

// 📥 Ανέβασμα εγγράφου για όχημα
router.post("/upload/:vehicleId", upload.single("file"), uploadDocument);

// 📂 Λίστα εγγράφων οχήματος
router.get("/:vehicleId", getVehicleDocuments);

// ⬇ Λήψη εγγράφου
router.get("/download/:filename", downloadDocument);

// 🗑️ Διαγραφή εγγράφου
router.delete("/:id", deleteDocument);

export default router;
