import jwt from "jsonwebtoken";

// middleware/authMiddleware.js

export function requireAuth(req, res, next) {
  if (!req.user) {
    return res.status(401).json({ message: "Unauthorized" });
  }
  next();
}

export function requireAdmin(req, res, next) {
  if (req.user.role !== "admin") {
    return res.status(403).json({ message: "Access denied" });
  }
  next();
}

export function requireBranchAdminOrAdmin(req, res, next) {
  if (req.user.role !== "admin" && req.user.role !== "branch_admin") {
    return res.status(403).json({ message: "Access denied" });
  }
  next();
}
