// controllers/vehicleDocumentController.js
import pool from "../db.js";
import fs from "fs";
import path from "path";



// controllers/vehicleDocumentController.js
export async function uploadDocument(req, res) {
  const vehicleId = req.params.vehicleId;
  const file = req.file;

  if (!file) {
    return res.status(400).json({ message: "No file uploaded" });
  }

  const conn = await pool.getConnection();
  await conn.query(
    "INSERT INTO vehicle_documents (vehicle_id, filename, filepath) VALUES (?, ?, ?)",
    [vehicleId, file.originalname, file.path]
  );
  res.status(201).json({ message: "File uploaded" });
}



// Επιστροφή εγγράφων για συγκεκριμένο όχημα
export async function getVehicleDocuments(req, res) {
  try {
    const conn = await pool.getConnection();
    const [rows] = await conn.query(
      "SELECT * FROM vehicle_documents WHERE vehicle_id = ?",
      [req.params.vehicleId]
    );
    res.json(rows);
  } catch (err) {
    console.error("❌ Error fetching vehicle documents:", err);
    res.status(500).json({ message: "Server error" });
  }
}


export async function deleteDocument(req, res) {
  const { id, docId } = req.params;
  try {
    const conn = await pool.getConnection();
    const [[doc]] = await conn.query("SELECT * FROM vehicle_documents WHERE id = ?", [docId]);

    if (!doc) return res.status(404).json({ message: "Document not found" });

    if (fs.existsSync(doc.filepath)) {
      fs.unlinkSync(doc.filepath);
    }

    await conn.query("DELETE FROM vehicle_documents WHERE id = ?", [docId]);

    res.json({ message: "Document deleted" });
  } catch (err) {
    console.error("❌ Delete error:", err);
    res.status(500).json({ message: "Server error" });
  }
}
