import jwt from "jsonwebtoken";
import bcrypt from "bcryptjs";
import pool from "../db.js";

export async function login(req, res) {
  const { username, password } = req.body;
  console.log("📨 Login request:", username, password);

  try {
    const conn = await pool.getConnection();
    console.log("🛠 DB connection established");

    const [rows] = await conn.query("SELECT * FROM users WHERE username = ?", [username]);
    console.log("🔍 Query result:", rows);

    if (rows.length === 0) {
      console.warn("❌ User not found");
      return res.status(401).json({ message: "User not found" });
    }

    const user = rows[0];
    console.log("✅ User found:", user);

    const match = await bcrypt.compare(password, user.password);
    console.log("🔐 Password match:", match);

    if (!match) {
      console.warn("❌ Invalid password");
      return res.status(401).json({ message: "Invalid credentials" });
    }

    const token = jwt.sign(
  { id: user.id, username: user.username, role: user.role, branch_id: user.branch_id },
  process.env.JWT_SECRET,
  { expiresIn: "1d" }

    );
    console.log("🎫 Token created:", token);

    res.json({
  token,
  user: {
    id: user.id,
    username: user.username,
    role: user.role,          // ✅ πρόσθεσε αυτό
    branch_id: user.branch_id // ✅ αν χρειάζεται
  }
});

  } catch (err) {
    console.error("❌ Login error:", err);
    res.status(500).json({ message: "Server error" });
  }
}
