import express from "express";
import cors from "cors";
import dotenv from "dotenv";
import jwt from "jsonwebtoken";

import userRoutes from "./routes/userRoutes.js";
import authRoutes from "./routes/auth.js";
import vehicleRoutes from "./routes/vehicleRoutes.js";
import vehicleDocumentRoutes from "./routes/vehicleDocumentRoutes.js";
import branchRoutes from "./routes/branchRoutes.js";
import vehicleLogbookRoutes from "./routes/vehicleLogbook.js";
import vehicleLogbookSignatureRoutes from "./routes/vehicleLogbookSignatures.js";
import cashRoutes from "./routes/cash.js";
import leaveRoutes from "./routes/leaves.js";
import leaveApproverRoutes from "./routes/leaveApprovers.js";
import uploadRoutes from "./routes/upload.js";
import employeeRoutes from "./routes/employees.js";
import employeeFileRoutes from "./routes/employeeFiles.js";
import payrollRoutes from "./routes/payrollRoutes.js";
import customerRoutes from "./routes/customerRoutes.js";
import ledgerRoutes from "./routes/ledgerRoutes.js";
import invoiceRoutes from "./routes/invoiceRoutes.js";
import invoicePaymentsRoutes from "./routes/invoicePaymentsRoutes.js";



dotenv.config();

const app = express();
app.use(cors());
app.use(express.json());

// ✅ Static αρχεία (όπως υπογραφές, παραστατικά κ.λπ.)
app.use("/uploads", express.static("uploads"));

// ✅ Ανοιχτά routes (δεν χρειάζονται token)
app.use("/api/auth", authRoutes);

// 🔐 Middleware για token authentication (μόνο για τα προστατευμένα)
app.use("/api", (req, res, next) => {
  const authHeader = req.headers.authorization;

  if (!authHeader || !authHeader.startsWith("Bearer ")) {
    return res.status(401).json({ message: "No token provided" });
  }

  const token = authHeader.split(" ")[1];
  try {
    const decoded = jwt.verify(token, process.env.JWT_SECRET);
    req.user = decoded;
    next();
  } catch (err) {
    return res.status(401).json({ message: "Invalid token" });
  }
});

// ✅ Protected API Routes
app.use("/api/users", userRoutes);
app.use("/api/vehicles", vehicleRoutes);
app.use("/api/vehicles/:vehicleId/documents", vehicleDocumentRoutes);
app.use("/api/branches", branchRoutes);
app.use("/api/vehicle-logbook", vehicleLogbookRoutes);
app.use("/api/vehicle-logbook", vehicleLogbookSignatureRoutes);
app.use("/api/cash-sessions", cashRoutes);
app.use("/api/leaves", leaveRoutes);
app.use("/api/leave-approvers", leaveApproverRoutes);
app.use("/api/upload", uploadRoutes);
app.use("/api/employees", employeeRoutes);
app.use("/api/employee-files", employeeFileRoutes);
app.use("/api/payrolls", payrollRoutes);
app.use("/api/customers", customerRoutes);
app.use("/api/invoices", invoiceRoutes);
app.use("/api/payments", invoicePaymentsRoutes);
app.use("/api/ledger", ledgerRoutes);
app.use("/api/invoice-payments", invoicePaymentsRoutes);



// ✅ Start server
app.listen(5000, () => {
  console.log("🚀 Server running on port 5000");
});
