import express from "express";
import { requireAuth as verifyToken } from "../middleware/authMiddleware.js";
import multer from "multer";
import db from "../db.js";
import {
  getVehicles,
  createVehicle,
  updateVehicle,
  deleteVehicle,
} from "../controllers/vehicleController.js";

const router = express.Router();

// === File Upload Config (deprecated here) ===
// Κρατάμε αυτό προσωρινά μόνο αν δεν έχει γίνει refactor ακόμα το vehicleDocumentRoutes.js
const storage = multer.diskStorage({
  destination: "uploads/vehicle-documents",
  filename: (req, file, cb) => {
    cb(null, Date.now() + "-" + file.originalname);
  },
});
const upload = multer({ storage });

// === Vehicle CRUD ===
router.get("/", verifyToken, getVehicles);
router.post("/", verifyToken, createVehicle);
router.put("/:id", verifyToken, updateVehicle);
router.delete("/:id", verifyToken, deleteVehicle);

// === Vehicle Stats Dashboard ===
router.get("/stats/dashboard", verifyToken, async (req, res) => {
  try {
    const [rows] = await db.query(`
      SELECT status AS status_code, COUNT(*) AS total
      FROM vehicles
      GROUP BY status
    `);
    res.json(rows);
  } catch (err) {
    console.error("Error fetching vehicle stats:", err);
    res.status(500).json({ message: err.message });
  }
});

export default router;
