import express from "express";
import {
  createLogbookEntry,
  returnVehicle,
  getLogbookEntries,
  getLogbookEntryById,
  deleteLogbookEntry
} from "../controllers/vehicleLogbookController.js";
import { updateLogbookEntry } from '../controllers/vehicleLogbookController.js';
import { requireAuth } from "../middleware/authMiddleware.js";
import { uploadSignature } from "../utils/upload.js";


const router = express.Router();

router.use(requireAuth);

router.get("/", getLogbookEntries);
router.get("/:id", getLogbookEntryById);
router.post("/", createLogbookEntry);
router.put("/:id/return", returnVehicle);
router.delete("/:id", deleteLogbookEntry);
router.put("/:id", updateLogbookEntry);
export default router;
