import { Router } from "express";
import {
  uploadDocument,
  getVehicleDocuments,
  deleteVehicleDocument,
  downloadVehicleDocument,
} from "../controllers/vehicleDocumentController.js";
import { upload } from "../utils/upload.js";

const router = Router();

router.post("/:vehicleId/upload", upload.single("file"), uploadDocument);
router.get("/:vehicleId", getVehicleDocuments);
router.delete("/:id", deleteVehicleDocument);

// ΝΕΟ: Download route
router.get("/download/:filename", downloadVehicleDocument);

export default router;
