// src/routes/vehicleDocumentRoutes.js
import express from "express";
import { uploadVehicleDoc as upload } from "../utils/upload.js";
import {
  uploadDocument,
  getVehicleDocuments,
  downloadDocumentById,
  deleteDocumentById,
} from "../controllers/vehicleDocumentController.js";

const router = express.Router({ mergeParams: true });

// 📥 Upload document
router.post("/", upload.single("file"), uploadDocument);

// 📂 List vehicle documents
router.get("/", getVehicleDocuments);

// ⬇ Download single document by id
router.get("/:docId", downloadDocumentById);

// 🗑️ Delete single document by id
router.delete("/:docId", deleteDocumentById);

export default router;
