import express from "express";
import {
  getUsers,
  getAllUsers,
  createUser,
  updateUser,
  deleteUser,
  changePassword,
} from "../controllers/userController.js";

import {
  requireAuth,
  requireAdmin,
  requireBranchAdminOrAdmin,
} from "../middleware/authMiddleware.js";

const router = express.Router();

router.get("/", requireAuth, requireBranchAdminOrAdmin, getUsers);
router.get("/all", requireAuth, requireAdmin, getAllUsers);
router.post("/", requireAuth, requireBranchAdminOrAdmin, createUser);
router.put("/:id", requireAuth, requireBranchAdminOrAdmin, updateUser);
router.delete("/:id", requireAuth, requireAdmin, deleteUser);
router.post("/change-password", requireAuth, changePassword);

export default router;
