import express from "express";
import {
  getPayrolls,
  getPayrollDetails,
  createPayroll,
  updatePayroll,
  deletePayroll,
} from "../controllers/payrollController.js";
import {
  getItemsByPayroll,
  createItem,
  deleteItem,
} from "../controllers/payrollItemsController.js";
import {
  getPaymentsByItem,
  createPayment,
  deletePayment,
} from "../controllers/payrollPaymentsController.js";

const router = express.Router();

// === Payroll ===
router.get("/", getPayrolls);
router.get("/details/:id", getPayrollDetails);
router.post("/", createPayroll);
router.put("/:id", updatePayroll);
router.delete("/:id", deletePayroll);

// === Payroll Items ===
router.get("/:payrollId/items", getItemsByPayroll);
router.post("/:payrollId/items", createItem);
router.delete("/items/:id", deleteItem);

// === Payroll Payments ===
router.get("/items/:itemId/payments", getPaymentsByItem);
router.post("/payments", createPayment);
router.delete("/payments/:id", deletePayment);

export default router;
