import express from "express";
import {
  createLeaveRequest,
  getLeaveRequests,
  getMyLeaves,
  approveLeave,
  rejectLeave
} from "../controllers/leaveController.js";
import { requireAuth } from "../middleware/authMiddleware.js";

const router = express.Router();

router.post("/", requireAuth, createLeaveRequest);
router.get("/", requireAuth, getLeaveRequests);
router.get("/mine", requireAuth, getMyLeaves);
router.put("/:id/approve", requireAuth, approveLeave);
router.put("/:id/reject", requireAuth, rejectLeave);

export default router;
