import express from "express";
import {
  getApprovers,
  createApprover,
  deleteApprover
} from "../controllers/leaveApproverController.js";
import { requireAuth, requireAdmin } from "../middleware/authMiddleware.js";

const router = express.Router();

router.get("/", requireAuth, requireAdmin, getApprovers);
router.post("/", requireAuth, requireAdmin, createApprover);
router.delete("/:id", requireAuth, requireAdmin, deleteApprover);

export default router;
