import express from "express";
import {
  getInvoices,
  createInvoice,
  getInvoiceById,
  deleteInvoice,
} from "../controllers/invoicesController.js";

const router = express.Router();

router.get("/", getInvoices);
router.post("/", createInvoice);
router.get("/:id", getInvoiceById);
router.delete("/:id", deleteInvoice);

export default router;
