import express from "express";
import {
  getAllInvoicePayments,
  getInvoicePayment,
  getPaymentsByCustomer, // ✅ (αν το χρειάζεσαι — δες παρακάτω)
  addInvoicePayment,
  deleteInvoicePayment,
} from "../controllers/invoicePaymentsController.js";

const router = express.Router();

/**
 * 🔹 GET /api/invoice-payments
 * Επιστρέφει όλες τις πληρωμές
 */
router.get("/", getAllInvoicePayments);

/**
 * 🔹 GET /api/invoice-payments/payment/:id
 * Επιστρέφει συγκεκριμένη πληρωμή
 */
router.get("/payment/:id", getInvoicePayment);

/**
 * 🔹 GET /api/invoice-payments/customer/:customer_id
 * Επιστρέφει όλες τις πληρωμές ενός πελάτη
 */
router.get("/customer/:customer_id", getPaymentsByCustomer);

/**
 * 🔹 POST /api/invoice-payments
 * Δημιουργεί νέα πληρωμή
 */
router.post("/", addInvoicePayment);

/**
 * 🔹 DELETE /api/invoice-payments/:id
 * Διαγράφει πληρωμή
 */
router.delete("/:id", deleteInvoicePayment);

export default router;
