const express = require('express');
const router = express.Router();
const {
  getAllEquipment,
  getEquipmentById,
  createEquipment,
  updateEquipment,
  deleteEquipment,
  assignEquipment,
  unassignEquipment,
  exportEquipmentToExcel,
  getEquipmentStats
} = require('../controllers/equipmentController');
const { verifyToken, isAdmin } = require('../middleware/authMiddleware');

// CRUD
router.get('/', verifyToken, getAllEquipment);
router.get('/:id', verifyToken, getEquipmentById);
router.post('/', verifyToken, isAdmin, createEquipment);
router.put('/:id', verifyToken, isAdmin, updateEquipment);
router.delete('/:id', verifyToken, isAdmin, deleteEquipment);

// Assignment
router.post('/:id/assign', verifyToken, isAdmin, assignEquipment);
router.post('/:id/unassign', verifyToken, isAdmin, unassignEquipment);

// Extras
router.get('/export/xlsx', verifyToken, isAdmin, exportEquipmentToExcel);
router.get('/stats/dashboard', verifyToken, getEquipmentStats);

module.exports = router;
