import express from "express";
import {
  createEmployeeFile,
  getEmployeeFiles,
  deleteEmployeeFile,
} from "../controllers/employeeFileController.js";
import { uploadEmployeeFile } from "../utils/upload.js";

const router = express.Router();

router.get("/:employeeId", getEmployeeFiles);
router.post("/", uploadEmployeeFile.single("file"), createEmployeeFile);
router.delete("/:id", deleteEmployeeFile);

export default router;
