// routes/customerRoutes.js
import express from "express";
import {
  getCustomers,
  getCustomer,
  createCustomer,
  updateCustomer,
  deleteCustomer,
  importCustomers,
  uploadMiddleware,
} from "../controllers/customersController.js";
import { getOverdueCustomers } from "../controllers/customersController.js";


const router = express.Router();

router.get("/", getCustomers);
router.get("/:id", getCustomer);
router.post("/", createCustomer);
router.put("/:id", updateCustomer);
router.delete("/:id", deleteCustomer);
router.post("/import", uploadMiddleware, importCustomers);
router.get("/overdue", getOverdueCustomers);
export default router;
