import express from "express";
import  pool  from "../db.js";
import {
  getBranches,
  createBranch,
  updateBranch,
  deleteBranch,
} from "../controllers/branchController.js";
import { requireAuth, requireAdmin } from "../middleware/authMiddleware.js";

const router = express.Router();

router.get("/", requireAuth, getBranches);
router.post("/", requireAdmin, createBranch);
router.put("/:id", requireAdmin, updateBranch);
router.delete("/:id", requireAdmin, deleteBranch);
router.get("/", async (req, res) => {
  try {
    const [rows] = await pool.query("SELECT id, name FROM branches");
    res.json(rows);
  } catch (err) {
    console.error("❌ Error loading branches", err);
    res.status(500).json({ message: "Server error" });
  }
});

export default router;
