import express from "express";
import {
  getBranches,
  getBranchById,
  createBranch,
  updateBranch,
  deleteBranch,
} from "../controllers/branchController.js";
import { requireAuth as verifyToken } from "../middleware/authMiddleware.js";

const router = express.Router();

// === Branch CRUD ===
router.get("/", verifyToken, getBranches);
router.get("/:id", verifyToken, getBranchById);
router.post("/", verifyToken, createBranch);
router.put("/:id", verifyToken, updateBranch);
router.delete("/:id", verifyToken, deleteBranch);

export default router;
