import multer from "multer";
import path from "path";
import { fileURLToPath } from "url";

const __filename = fileURLToPath(import.meta.url);
const __dirname = path.dirname(__filename);

// Γενική βοηθητική συνάρτηση
const makeStorage = (folderPrefix, filePrefix) =>
  multer.diskStorage({
    destination: (req, file, cb) => {
      cb(null, `uploads/${folderPrefix}`);
    },
    filename: (req, file, cb) => {
      const ext = path.extname(file.originalname);
      cb(null, `${filePrefix}_${Date.now()}${ext}`);
    },
  });

// === Vehicle documents ===
export const uploadVehicleDoc = multer({
  storage: makeStorage("vehicle_docs", "vehicle"),
});

// === Υπογραφές ===
export const uploadSignature = multer({
  storage: makeStorage("signatures", "signature"),
});

// === Παραστατικά εξόδων ===
export const uploadExpense = multer({
  storage: makeStorage("expenses", "expense"),
});

// === Employee Files ===
export const uploadEmployeeFile = multer({
  storage: makeStorage("employee_files", "employee"),
});
